/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.crypto.IvParameters;
import au.gov.bafcsi.common.ByteArray;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public class CsiIvParameters
extends AlgorithmParametersSpi {
    private IvParameterSpec ivParams;
    private IvParameters tree = new IvParameters();

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException("CSIIVParameters.engineInit(AlgorithmParameterSpec) - " + algorithmParameterSpec.getClass().getName() + " not supported, expected IvParameterSpec.");
        }
        this.ivParams = (IvParameterSpec)algorithmParameterSpec;
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            this.tree.a(new ByteArray(byArray, false));
            this.ivParams = new IvParameterSpec(this.tree.j().getBytes());
        }
        catch (CoderException coderException) {
            throw new IOException("CSIIVParameters.engineInit(byte[]) - " + coderException.getMessage());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (!clazz.equals(IvParameterSpec.class)) {
            throw new InvalidParameterSpecException("CSIIVParameters.engineGetParameterSpec(Class) - " + clazz.getName() + " not supported, expected IvParameterSpec.");
        }
        return this.ivParams;
    }

    protected byte[] engineGetEncoded() throws IOException {
        try {
            return this.tree.g().getBytes();
        }
        catch (CoderException coderException) {
            throw new IOException("CSIIVParameters.engineGetEncoded() - " + coderException.getMessage());
        }
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        return "IV Parameters";
    }
}

