/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.crypto.Pkcs1EncodedRsaPrivateKey;
import au.gov.bafcsi.clapi.crypto.Pkcs8EncodedPrivateKey;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;

public class CsiRsaPrivateKey
implements RSAPrivateKey {
    private BigInteger modulus;
    private BigInteger publicExp;
    private BigInteger privateExp;
    private BigInteger p;
    private BigInteger q;
    private BigInteger expP;
    private BigInteger expQ;
    private BigInteger coefficient;
    private boolean m_isCrtPrivateKey;

    public CsiRsaPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.modulus = bigInteger;
        this.publicExp = bigInteger2;
        this.privateExp = bigInteger3;
        this.p = bigInteger4;
        this.q = bigInteger5;
        this.expP = bigInteger6;
        this.expQ = bigInteger7;
        this.coefficient = bigInteger8;
        this.m_isCrtPrivateKey = true;
    }

    public CsiRsaPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.modulus = bigInteger;
        this.privateExp = bigInteger3;
        this.publicExp = bigInteger2;
        this.m_isCrtPrivateKey = false;
    }

    public CsiRsaPrivateKey(Pkcs1EncodedRsaPrivateKey pkcs1EncodedRsaPrivateKey) {
        if (pkcs1EncodedRsaPrivateKey == null) {
            throw new IllegalArgumentException("CsiRsaPrivateKey(Pkcs1EncodedRsaPrivateKey) - Pkcs1EncodedRsaPrivateKey is null.");
        }
        this.modulus = pkcs1EncodedRsaPrivateKey.getModulus();
        this.privateExp = pkcs1EncodedRsaPrivateKey.getPrivateExponent();
        this.publicExp = pkcs1EncodedRsaPrivateKey.getPublicExponent();
        this.p = pkcs1EncodedRsaPrivateKey.getPrime1();
        this.q = pkcs1EncodedRsaPrivateKey.getPrime2();
        this.expP = pkcs1EncodedRsaPrivateKey.getExponent1();
        this.expQ = pkcs1EncodedRsaPrivateKey.getExponent2();
        this.coefficient = pkcs1EncodedRsaPrivateKey.getCoefficient();
        this.m_isCrtPrivateKey = true;
    }

    public BigInteger getPublicExponent() {
        return this.publicExp;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExp;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public boolean isCrtPrivateKey() {
        return this.m_isCrtPrivateKey;
    }

    public byte[] getEncoded() {
        try {
            return new Pkcs8EncodedPrivateKey(this, null).g().getBytes();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExp() {
        return this.publicExp;
    }

    public BigInteger getPrivateExp() {
        return this.privateExp;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getCrtExpP() {
        return this.expP;
    }

    public BigInteger getCrtExpQ() {
        return this.expQ;
    }

    public BigInteger getCrtCoefficient() {
        return this.coefficient;
    }
}

