/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.certs.SubjectPublicKeyInfo;
import au.gov.bafcsi.clapi.crypto.Pkcs1EncodedRsaPublicKey;
import au.gov.bafcsi.common.ByteArray;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;

public class CsiRsaPublicKey
implements RSAPublicKey {
    private BigInteger publicExponent;
    private BigInteger modulus;
    private ByteArray encoding;

    public CsiRsaPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
        this.encoding = null;
    }

    public CsiRsaPublicKey(Pkcs1EncodedRsaPublicKey pkcs1EncodedRsaPublicKey) {
        this.modulus = pkcs1EncodedRsaPublicKey.getModulus();
        this.publicExponent = pkcs1EncodedRsaPublicKey.getPublicExponent();
    }

    public CsiRsaPublicKey(X509EncodedKeySpec x509EncodedKeySpec) throws IOException, CoderException {
        this.encoding = new ByteArray(x509EncodedKeySpec.getEncoded());
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo();
        subjectPublicKeyInfo.a(this.encoding);
        Pkcs1EncodedRsaPublicKey pkcs1EncodedRsaPublicKey = new Pkcs1EncodedRsaPublicKey();
        pkcs1EncodedRsaPublicKey.a(subjectPublicKeyInfo.getSubjectPublicKey());
        this.modulus = pkcs1EncodedRsaPublicKey.getModulus();
        this.publicExponent = pkcs1EncodedRsaPublicKey.getPublicExponent();
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        try {
            return new SubjectPublicKeyInfo(this).g().getBytes();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof PublicKey)) {
            return false;
        }
        return Arrays.equals(this.getEncoded(), ((PublicKey)object).getEncoded());
    }
}

