/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.certs.CsiX509Certificate;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.crypto.PKCS11Exception;
import au.gov.bafcsi.clapi.crypto.PKCS11Module;
import au.gov.bafcsi.clapi.crypto.PKCS11Object;
import au.gov.bafcsi.clapi.crypto.PKCS11TokenInfo;
import au.gov.bafcsi.clapi.crypto.UserCancelledSignatureException;
import au.gov.bafcsi.clapi.crypto.ge;
import au.gov.bafcsi.clapi.crypto.gf;
import au.gov.bafcsi.clapi.crypto.gi;
import au.gov.bafcsi.clapi.crypto.gj;
import au.gov.bafcsi.clapi.crypto.gk;
import au.gov.bafcsi.clapi.crypto.gl;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.cz;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.de;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.ae;
import au.gov.bafcsi.common.utils.q;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.s;
import au.gov.bafcsi.common.utils.w;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.crypto.SecretKey;

public final class PKCS11Slot {
    public static final int CKM_MD2 = 512;
    public static final int CKM_MD5 = 528;
    public static final int CKM_SHA_1 = 544;
    public static final int CKM_RSA_PKCS = 1;
    public static final int CKM_RSA_X_509 = 3;
    public static final int CKM_MD2_RSA_PKCS = 4;
    public static final int CKM_MD5_RSA_PKCS = 5;
    public static final int CKM_SHA1_RSA_PKCS = 6;
    public static final int CKC_X_509 = 0;
    public static final int CKU_SO = 0;
    public static final int CKU_USER = 1;
    public static final int CKO_CERTIFICATE = 1;
    public static final int CKO_PUBLIC_KEY = 2;
    public static final int CKO_PRIVATE_KEY = 3;
    private PKCS11Module module;
    private int slotId;
    public static final int TEST_PASSED = 0;
    public static final int FAILED_ON_TOKEN_PRESENT = 1;
    public static final int TOKEN_NOT_PRESENT = 2;
    public static final int NO_USER_CERTIFICATES = 3;
    public static final int SESSION_COULD_NOT_BE_OPENED = 4;
    public static final int FAILED_ON_LOGIN = 5;
    public static final int FAILED_ON_SIGN = 6;
    public static final int FAILED_ON_VERIFY = 7;
    public static final int FAILED_ON_NUMBER_OF_CERTIFICATES = 8;
    public static final int FAILED_ON_GET_CERTIFICATES = 9;
    public static final int FAILED_ON_DECODE_CERTIFICATE = 10;
    public static final int FAILED_ON_UNWRAP = 11;
    public static final int SIGNATURE_DID_NOT_VERIFY = 12;
    public static final int FAILED_ON_SET_CALL_2ND_INIT = 13;
    public static final int FAILED = 14;

    private native boolean tokenPresent(int var1, int var2) throws PKCS11Exception;

    private native PKCS11TokenInfo getTokenInfo(int var1, int var2) throws PKCS11Exception;

    private native void openSession(int var1, int var2) throws PKCS11Exception;

    private native void closeSession(int var1, int var2) throws PKCS11Exception;

    private native boolean getSessionOpened(int var1, int var2) throws PKCS11Exception;

    private native void closeAllSessions(int var1, int var2) throws PKCS11Exception;

    private native void login(int var1, int var2, String var3, int var4) throws PKCS11Exception;

    private native void logout(int var1, int var2) throws PKCS11Exception;

    private native void setPIN(int var1, int var2, String var3, String var4) throws PKCS11Exception;

    private native void setCall2ndInit(int var1, int var2, boolean var3) throws PKCS11Exception;

    private native void initToken(int var1, int var2, String var3, String var4) throws PKCS11Exception;

    private native void initPIN(int var1, int var2, String var3) throws PKCS11Exception;

    private native void initTokenAndUserPIN(int var1, int var2, String var3, String var4, String var5) throws PKCS11Exception;

    private native void seedRandom(int var1, int var2, byte[] var3) throws PKCS11Exception;

    private native byte[] generateRandom(int var1, int var2, int var3) throws PKCS11Exception;

    private native int getNumberOfCertificates(int var1, int var2, int var3) throws PKCS11Exception;

    private native byte[] getCertificate(int var1, int var2, int var3, int var4) throws PKCS11Exception;

    private native boolean deleteCertificate(int var1, int var2, int var3, byte[] var4, boolean var5, boolean var6) throws PKCS11Exception;

    private native int getNumberOfObjects(int var1, int var2, int var3) throws PKCS11Exception;

    private native PKCS11Object getObject(int var1, int var2, int var3, int var4) throws PKCS11Exception;

    private native boolean deleteObject(int var1, int var2, int var3) throws PKCS11Exception;

    private native byte[] signData(int var1, int var2, byte[] var3, byte[] var4, int var5) throws PKCS11Exception;

    private native byte[] unwrapKey(int var1, int var2, byte[] var3, byte[] var4, int var5) throws PKCS11Exception;

    private native void digestInit(int var1, int var2, int var3) throws PKCS11Exception;

    private native void digestUpdate(int var1, int var2, byte[] var3) throws PKCS11Exception;

    private native byte[] digestFinal(int var1, int var2) throws PKCS11Exception;

    private native byte[] encryptData(int var1, int var2, byte[] var3, byte[] var4, int var5) throws PKCS11Exception;

    private native byte[] decryptData(int var1, int var2, byte[] var3, byte[] var4, int var5) throws PKCS11Exception;

    private native boolean verifyData(int var1, int var2, byte[] var3, byte[] var4, byte[] var5, int var6) throws PKCS11Exception;

    PKCS11Slot(PKCS11Module pKCS11Module, int n10) {
        if (pKCS11Module == null) {
            throw new IllegalArgumentException("PKCS11Slot(PKCS11Module, int) - The PKCS11Module argument is null.");
        }
        if (n10 < 0) {
            throw new IllegalArgumentException("PKCS11Slot(PKCS11Module, int) - The supplied int < 0.");
        }
        this.module = pKCS11Module;
        this.slotId = n10;
    }

    public int getSlotId() {
        return this.slotId;
    }

    public boolean tokenPresent() throws PKCS11Exception {
        return this.tokenPresent(this.module.getModuleID(), this.slotId);
    }

    public boolean userLoginRequired() throws PKCS11Exception {
        PKCS11TokenInfo pKCS11TokenInfo = this.getTokenInfo();
        return pKCS11TokenInfo.userLoginRequired();
    }

    public boolean hasRandomNumberGenerator() throws PKCS11Exception {
        PKCS11TokenInfo pKCS11TokenInfo = this.getTokenInfo();
        return pKCS11TokenInfo.hasRandomNumberGenerator();
    }

    public PKCS11TokenInfo getTokenInfo() throws PKCS11Exception {
        return this.getTokenInfo(this.module.getModuleID(), this.slotId);
    }

    public void openSession() throws PKCS11Exception {
        this.openSession(this.module.getModuleID(), this.slotId);
    }

    public void closeSession() throws PKCS11Exception {
        this.closeSession(this.module.getModuleID(), this.slotId);
    }

    public boolean getSessionOpened() throws PKCS11Exception {
        return this.getSessionOpened(this.module.getModuleID(), this.slotId);
    }

    public void closeAllSessions() throws PKCS11Exception {
        this.closeAllSessions(this.module.getModuleID(), this.slotId);
    }

    public void login(gf gf2, CsiCertificate csiCertificate) throws PKCS11Exception, gi, gj, gk {
        if (gf2 == null) {
            throw new IllegalArgumentException("PKCS11Slot.login(PasswordUsage, CsiCertificate) - The supplied PasswordUsage is null.");
        }
        if (csiCertificate == null) {
            throw new IllegalArgumentException("PKCS11Slot.login(PasswordUsage, CsiCertificate) - The supplied CsiCertificate is null.");
        }
        int n10 = 0;
        while (true) {
            String string;
            try {
                char[] cArray = s.a().an() ? (gf2 == gf.d ? ge.a(gf2, csiCertificate) : ge.a(gf2, csiCertificate)) : ge.a(gf2, csiCertificate);
                if (cArray == null) {
                    if (s.a().an()) {
                        string = "The PIN for the PKC#11 token could not be retrieved when running in server mode (subject cn = " + csiCertificate.getSubjectCommonName() + ", issuer cn = " + csiCertificate.getIssuerCommonName() + ", serial #" + csiCertificate.getSerialNumber().toString() + ", reason = " + gf2.e + ").  " + "The operation was cancelled.";
                        throw new gi(w.f, string);
                    }
                    throw new gi("The user cancelled out of the PKCS#11 PIN dialog.");
                }
                this.login(this.module.getModuleID(), this.slotId, new String(cArray), 1);
                Arrays.fill(cArray, '\u0000');
                cArray = null;
            }
            catch (PKCS11Exception pKCS11Exception) {
                string = pKCS11Exception.getMessage();
                if (string.indexOf("CKR_PIN_INCORRECT") != -1) {
                    if (s.a().an()) {
                        String string2 = "The PKCS#11 PIN provided to the CSI is incorrect (subject cn = " + csiCertificate.getSubjectCommonName() + ", issuer cn = " + csiCertificate.getIssuerCommonName() + ", serial #" + csiCertificate.getSerialNumber().toString() + ", reason = " + gf2.e + ").  " + "The operation was cancelled.";
                        throw new gj(string2);
                    }
                } else {
                    throw pKCS11Exception;
                }
                ae.a("The supplied password is incorrect.", "CSI - Warning", 2);
                if (++n10 < 3) continue;
                throw new gk("User entered the wrong PIN 3 times. User was attempting to access a PKCS#11 token.", 3);
            }
            break;
        }
    }

    public void login(String string) throws PKCS11Exception {
        if (string == null) {
            throw new IllegalArgumentException("PKCS11Slot.login(String) - The supplied String is null.");
        }
        this.login(this.module.getModuleID(), this.slotId, string, 1);
    }

    public void login(String string, int n10) throws PKCS11Exception {
        if (string == null) {
            throw new IllegalArgumentException("PKCS11Slot.login(String, int) - The supplied String is null.");
        }
        if (n10 != 1 || n10 != 0) {
            throw new IllegalArgumentException("PKCS11Slot.login(String, int) - The supplied userType must be either CKU_USER or CKU_SO.");
        }
        this.login(this.module.getModuleID(), this.slotId, string, n10);
    }

    public void logout() throws PKCS11Exception {
        this.logout(this.module.getModuleID(), this.slotId);
    }

    public void setPIN(String string, String string2) throws PKCS11Exception {
        if (string == null) {
            throw new IllegalArgumentException("PKCS11Slot.setPIN(String, String) - The supplied oldPIN is null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("PKCS11Slot.setPIN(String, String) - The supplied newPIN is null.");
        }
        try {
            this.setPIN(this.module.getModuleID(), this.slotId, string, string2);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                this.setPIN(this.module.getModuleID(), this.slotId, string, string2);
            }
            throw pKCS11Exception;
        }
    }

    public void initToken(String string, String string2) throws PKCS11Exception {
        if (string == null) {
            throw new IllegalArgumentException("PKCS11Slot.initToken(String, String) - The supplied pin is null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("PKCS11Slot.initToken(String, String) - The supplied label is null.");
        }
        try {
            this.initToken(this.module.getModuleID(), this.slotId, string, string2);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                if (pKCS11Exception.getMessage().indexOf("CKR_SESSION_EXISTS") != -1) {
                    this.closeSession();
                }
                this.initToken(this.module.getModuleID(), this.slotId, string, string2);
            }
            throw pKCS11Exception;
        }
    }

    public void initPIN(String string) throws PKCS11Exception {
        if (string == null) {
            throw new IllegalArgumentException("PKCS11Slot.initPIN(String) - The supplied pin is null.");
        }
        try {
            this.initPIN(this.module.getModuleID(), this.slotId, string);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                this.initPIN(this.module.getModuleID(), this.slotId, string);
            }
            throw pKCS11Exception;
        }
    }

    public void initTokenAndUserPIN(String string, String string2, String string3) throws PKCS11Exception {
        if (string == null) {
            throw new IllegalArgumentException("PKCS11Slot.initTokenAndUserPIN(String, String, String) - The supplied sopin is null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("PKCS11Slot.initTokenAndUserPIN(String, String, String) - The supplied label is null.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("PKCS11Slot.initTokenAndUserPIN(String, String, String) - The supplied userpin is null.");
        }
        try {
            this.initTokenAndUserPIN(this.module.getModuleID(), this.slotId, string, string2, string3);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                this.initTokenAndUserPIN(this.module.getModuleID(), this.slotId, string, string2, string3);
            }
            throw pKCS11Exception;
        }
    }

    public void setCall2ndInit(boolean bl2) throws PKCS11Exception {
        try {
            this.setCall2ndInit(this.module.getModuleID(), this.slotId, bl2);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                this.setCall2ndInit(this.module.getModuleID(), this.slotId, bl2);
            }
            throw pKCS11Exception;
        }
    }

    public int getNumberOfCertificates() throws PKCS11Exception {
        try {
            return this.getNumberOfCertificates(this.module.getModuleID(), this.slotId, 0);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                return this.getNumberOfCertificates(this.module.getModuleID(), this.slotId, 0);
            }
            throw pKCS11Exception;
        }
    }

    public ByteArray getCertificate(int n10) throws PKCS11Exception {
        if (n10 < 0) {
            throw new IndexOutOfBoundsException("PKCS11Module.getPKCS11Slot(int) - index cannot be negative.");
        }
        try {
            return new ByteArray(this.getCertificate(this.module.getModuleID(), this.slotId, 0, n10));
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                return new ByteArray(this.getCertificate(this.module.getModuleID(), this.slotId, 0, n10));
            }
            throw pKCS11Exception;
        }
    }

    public boolean deleteCertificate(ByteArray byteArray) throws PKCS11Exception {
        return this.deleteCertificate(byteArray, true, true);
    }

    public boolean deleteCertificate(ByteArray byteArray, boolean bl2, boolean bl3) throws PKCS11Exception {
        if (byteArray == null) {
            throw new IllegalArgumentException("PKCS11Module.deleteCertificate(ByteArray, boolean, boolean) - The supplied ByteArray is null.");
        }
        try {
            return this.deleteCertificate(this.module.getModuleID(), this.slotId, 0, byteArray.getBytes(), bl2, bl3);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                return this.deleteCertificate(this.module.getModuleID(), this.slotId, 0, byteArray.getBytes(), bl2, bl3);
            }
            throw pKCS11Exception;
        }
    }

    public int getNumberOfObjects(int n10) throws PKCS11Exception {
        try {
            return this.getNumberOfObjects(this.module.getModuleID(), this.slotId, n10);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                return this.getNumberOfObjects(this.module.getModuleID(), this.slotId, n10);
            }
            throw pKCS11Exception;
        }
    }

    public PKCS11Object getObject(int n10, int n11) throws PKCS11Exception {
        if (n11 < 0) {
            throw new IndexOutOfBoundsException("PKCS11Module.getObject(int, int) - index cannot be negative.");
        }
        try {
            return this.getObject(this.module.getModuleID(), this.slotId, n10, n11);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                return this.getObject(this.module.getModuleID(), this.slotId, n10, n11);
            }
            throw pKCS11Exception;
        }
    }

    public boolean deleteObject(PKCS11Object pKCS11Object) throws PKCS11Exception {
        if (pKCS11Object == null) {
            throw new IllegalArgumentException("PKCS11Slot(PKCS11Object) - The supplied PKCS11Object is null.");
        }
        try {
            return this.deleteObject(this.module.getModuleID(), this.slotId, pKCS11Object.getObjectId());
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                return this.deleteObject(this.module.getModuleID(), this.slotId, pKCS11Object.getObjectId());
            }
            throw pKCS11Exception;
        }
    }

    public void digestInit(int n10) throws PKCS11Exception {
        try {
            this.digestInit(this.module.getModuleID(), this.slotId, n10);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                this.digestInit(this.module.getModuleID(), this.slotId, n10);
            }
            throw pKCS11Exception;
        }
    }

    public void digestUpdate(ByteArray byteArray) throws PKCS11Exception {
        if (byteArray == null) {
            throw new IllegalArgumentException("PKCS11Slot.digestUpdate(ByteArray) - The ByteArray argument is null.");
        }
        try {
            this.digestUpdate(this.module.getModuleID(), this.slotId, byteArray.getBytes());
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                this.digestUpdate(this.module.getModuleID(), this.slotId, byteArray.getBytes());
            }
            throw pKCS11Exception;
        }
    }

    public ByteArray digestFinal() throws PKCS11Exception {
        try {
            return new ByteArray(this.digestFinal(this.module.getModuleID(), this.slotId));
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                return new ByteArray(this.digestFinal(this.module.getModuleID(), this.slotId));
            }
            throw pKCS11Exception;
        }
    }

    public void seedRandom(byte[] byArray) throws PKCS11Exception {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("PKCS11Module.seedRandom(byte[]) - The supplied byte[] is null or of length 0.");
        }
        try {
            this.seedRandom(this.module.getModuleID(), this.slotId, byArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                this.seedRandom(this.module.getModuleID(), this.slotId, byArray);
            }
            throw pKCS11Exception;
        }
    }

    public ByteArray generateRandom(int n10) throws PKCS11Exception {
        if (n10 <= 0) {
            throw new IllegalArgumentException("PKCS11Module.generateRandom(int) - numberOfBytes is <= 0.");
        }
        try {
            return new ByteArray(this.generateRandom(this.module.getModuleID(), this.slotId, n10));
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                return new ByteArray(this.generateRandom(this.module.getModuleID(), this.slotId, n10));
            }
            throw pKCS11Exception;
        }
    }

    public ByteArray encryptData(ByteArray byteArray, ByteArray byteArray2, int n10) throws PKCS11Exception {
        if (byteArray == null) {
            throw new IllegalArgumentException("PKCS11Slot.encryptData(ByteArray, ByteArray) - The certificate is null.");
        }
        if (byteArray2 == null) {
            throw new IllegalArgumentException("PKCS11Slot.encryptData(ByteArray, ByteArray) - The plaintext is null.");
        }
        try {
            return new ByteArray(this.encryptData(this.module.getModuleID(), this.slotId, byteArray.getBytes(), byteArray2.getBytes(), n10));
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                return new ByteArray(this.encryptData(this.module.getModuleID(), this.slotId, byteArray.getBytes(), byteArray2.getBytes(), n10));
            }
            throw pKCS11Exception;
        }
    }

    public ByteArray decryptData(ByteArray byteArray, ByteArray byteArray2, int n10) throws PKCS11Exception {
        if (byteArray == null) {
            throw new IllegalArgumentException("PKCS11Slot.decryptData(ByteArray, ByteArray) - The certificate is null.");
        }
        if (byteArray2 == null) {
            throw new IllegalArgumentException("PKCS11Slot.decryptData(ByteArray, ByteArray) - The ciphertext is null.");
        }
        try {
            return new ByteArray(this.decryptData(this.module.getModuleID(), this.slotId, byteArray.getBytes(), byteArray2.getBytes(), n10));
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                return new ByteArray(this.decryptData(this.module.getModuleID(), this.slotId, byteArray.getBytes(), byteArray2.getBytes(), n10));
            }
            throw pKCS11Exception;
        }
    }

    public ByteArray signData(ByteArray byteArray, ByteArray byteArray2, int n10) throws PKCS11Exception {
        if (byteArray == null) {
            throw new IllegalArgumentException("PKCS11Slot.signData(ByteArray, ByteArray) - The certificate is null.");
        }
        if (byteArray2 == null) {
            throw new IllegalArgumentException("PKCS11Slot.signData(ByteArray, ByteArray) - The data is null.");
        }
        try {
            return new ByteArray(this.signData(this.module.getModuleID(), this.slotId, byteArray.getBytes(), byteArray2.getBytes(), n10));
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                return new ByteArray(this.signData(this.module.getModuleID(), this.slotId, byteArray.getBytes(), byteArray2.getBytes(), n10));
            }
            throw pKCS11Exception;
        }
    }

    public boolean verifyData(ByteArray byteArray, ByteArray byteArray2, ByteArray byteArray3, int n10) throws PKCS11Exception {
        if (byteArray == null) {
            throw new IllegalArgumentException("PKCS11Slot.verifyData(ByteArray, ByteArray, ByteArray) - The certificate is null.");
        }
        if (byteArray2 == null) {
            throw new IllegalArgumentException("PKCS11Slot.verifyData(ByteArray, ByteArray, ByteArray) - The data is null.");
        }
        if (byteArray3 == null) {
            throw new IllegalArgumentException("PKCS11Slot.verifyData(ByteArray, ByteArray, ByteArray) - The signature is null.");
        }
        try {
            return this.verifyData(this.module.getModuleID(), this.slotId, byteArray.getBytes(), byteArray2.getBytes(), byteArray3.getBytes(), n10);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                return this.verifyData(this.module.getModuleID(), this.slotId, byteArray.getBytes(), byteArray2.getBytes(), byteArray3.getBytes(), n10);
            }
            throw pKCS11Exception;
        }
    }

    public ByteArray unwrapKey(ByteArray byteArray, ByteArray byteArray2, int n10) throws PKCS11Exception {
        if (byteArray == null) {
            throw new IllegalArgumentException("PKCS11Slot.unwrapKey(ByteArray, ByteArray) - The certificate is null.");
        }
        if (byteArray2 == null) {
            throw new IllegalArgumentException("PKCS11Slot.unwrapKey(ByteArray, ByteArray) - The wrappedKey is null.");
        }
        try {
            return new ByteArray(this.unwrapKey(this.module.getModuleID(), this.slotId, byteArray.getBytes(), byteArray2.getBytes(), n10));
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (this.tokenPresent() && pKCS11Exception.getMessage().indexOf("CKR_SESSION_CLOSED") != -1 || pKCS11Exception.getMessage().indexOf("CKR_DEVICE_REMOVED") != -1) {
                this.openSession();
                return new ByteArray(this.unwrapKey(this.module.getModuleID(), this.slotId, byteArray.getBytes(), byteArray2.getBytes(), n10));
            }
            throw pKCS11Exception;
        }
    }

    public int testPKCS11Slot(char[] cArray) throws UserCancelledSignatureException {
        int n10;
        try {
            if (!this.tokenPresent()) {
                gl gl2 = new gl();
                while (!this.tokenPresent()) {
                    if (gl2.u()) continue;
                    throw new UserCancelledSignatureException("Pkcs11Slot.testPKCS11Slot() - User cancelled InsertTokenDialog");
                }
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            return 1;
        }
        try {
            if (!this.getSessionOpened()) {
                this.openSession();
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            return 4;
        }
        try {
            if (this.userLoginRequired()) {
                this.login(this.module.getModuleID(), this.slotId, new String(cArray), 1);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            return 5;
        }
        try {
            n10 = this.getNumberOfCertificates();
            if (n10 == 0) {
                return 3;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            return 8;
        }
        for (int i10 = 0; i10 < n10; ++i10) {
            ByteArray byteArray;
            try {
                byteArray = this.getCertificate(i10);
            }
            catch (PKCS11Exception pKCS11Exception) {
                return 9;
            }
            CsiX509Certificate csiX509Certificate = new CsiX509Certificate();
            try {
                csiX509Certificate.decode(new ByteArrayInputStream(byteArray.getBytes()));
            }
            catch (Exception exception) {
                return 10;
            }
            if (!csiX509Certificate.getPublicKey().getAlgorithm().equalsIgnoreCase("RSA")) continue;
            try {
                this.setCall2ndInit(false);
            }
            catch (PKCS11Exception pKCS11Exception) {
                r.a(w.f, "PKCS11Slot.testPKCS11Slot(): Error setting call 2nd init false; Module:" + this.module.getPKCS11Library(), pKCS11Exception);
                return 13;
            }
            try {
                int n11 = this.testWrapAndUnwrapKey(csiX509Certificate, byteArray);
                if (n11 == 0) {
                    s.a().a(this.module.getPKCS11Library(), false);
                }
                return n11;
            }
            catch (Exception exception) {
                r.a(w.f, "PKCS11Slot.testPKCS11Slot(): Error while wrapping or unwrapping (1); Module:" + this.module.getPKCS11Library(), exception);
                try {
                    this.setCall2ndInit(true);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    r.a(w.f, "PKCS11Slot.testPKCS11Slot(): Error setting call 2nd init true; Module:" + this.module.getPKCS11Library(), pKCS11Exception);
                    return 13;
                }
                try {
                    int n12 = this.testWrapAndUnwrapKey(csiX509Certificate, byteArray);
                    if (n12 == 0) {
                        s.a().a(this.module.getPKCS11Library(), true);
                        return 0;
                    }
                    return n12;
                }
                catch (Exception exception2) {
                    r.a(w.f, "PKCS11Slot.testPKCS11Slot(): Error while wrapping or unwrapping (2); Module:" + this.module.getPKCS11Library(), exception2);
                }
            }
        }
        return 14;
    }

    private int testWrapAndUnwrapKey(CsiX509Certificate csiX509Certificate, ByteArray byteArray) throws Exception, PKCS11Exception {
        cz cz2 = q.c("RSA");
        cz2.a(3, csiX509Certificate.getPublicKey());
        de de2 = q.a(Oids.des3CBC);
        de2.a(168);
        SecretKey secretKey = de2.a();
        byte[] byArray = cz2.a(secretKey);
        byte[] byArray2 = this.unwrapKey(this.module.getModuleID(), this.slotId, byteArray.getBytes(), byArray, 1);
        if (!new String(byArray2).equals(new String(secretKey.getEncoded()))) {
            return 11;
        }
        return 0;
    }

    public String encodeStore() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.module.getModuleID());
        stringBuffer.append(",");
        stringBuffer.append(this.slotId);
        return stringBuffer.toString();
    }

    public static int[] decodeStore(String string) throws PKCS11Exception {
        if (string == null) {
            throw new IllegalArgumentException("PKCS11Slot.decodeStore(String) - The encoding is null");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() != 2) {
            throw new PKCS11Exception("PKCS11Slot.decodeStore(String) - Error decoding '" + string + "'");
        }
        int[] nArray = new int[]{Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken())};
        return nArray;
    }

    public int testPKCS11Password(char[] cArray) throws UserCancelledSignatureException {
        try {
            if (!this.tokenPresent()) {
                gl gl2 = new gl();
                while (!this.tokenPresent()) {
                    if (gl2.u()) continue;
                    throw new UserCancelledSignatureException("Pkcs11Slot.testPKCS11Slot() - User cancelled InsertTokenDialog");
                }
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            return 1;
        }
        try {
            if (!this.getSessionOpened()) {
                this.openSession();
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            return 4;
        }
        try {
            if (this.userLoginRequired()) {
                this.login(this.module.getModuleID(), this.slotId, new String(cArray), 1);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            return 5;
        }
        try {
            this.logout(this.module.getModuleID(), this.slotId);
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        return 0;
    }
}

