/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

public final class PKCS11TokenInfo {
    private String label;
    private String manufacturerID;
    private String model;
    private String serialNumber;
    private int sessionCount;
    private boolean randomNumberGenerator;
    private boolean loginRequired;

    public PKCS11TokenInfo(String string, String string2, String string3, String string4, int n10, boolean bl2, boolean bl3) {
        this.label = string == null ? "?" : string;
        this.manufacturerID = string2 == null ? "?" : string2;
        this.model = string3 == null ? "?" : string3;
        this.serialNumber = string4 == null ? "?" : string4;
        this.sessionCount = n10;
        this.randomNumberGenerator = bl2;
        this.loginRequired = bl3;
    }

    public String getLabel() {
        return this.label;
    }

    public String getManufacturerID() {
        return this.manufacturerID;
    }

    public String getModel() {
        return this.model;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public int getSessionCount() {
        return this.sessionCount;
    }

    public boolean hasRandomNumberGenerator() {
        return this.randomNumberGenerator;
    }

    public boolean userLoginRequired() {
        return this.loginRequired;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Label = '");
        stringBuffer.append(this.label);
        stringBuffer.append("'\r\n");
        stringBuffer.append("ManufactuerID = '");
        stringBuffer.append(this.manufacturerID);
        stringBuffer.append("'\r\n");
        stringBuffer.append("Model = '");
        stringBuffer.append(this.model);
        stringBuffer.append("'\r\n");
        stringBuffer.append("SerialNumber = '");
        stringBuffer.append(this.serialNumber);
        stringBuffer.append("'\r\n");
        stringBuffer.append("SessionCount = ");
        stringBuffer.append(this.sessionCount);
        stringBuffer.append("\r\n");
        stringBuffer.append("RandomNumberGenerator = ");
        stringBuffer.append(this.randomNumberGenerator ? "True" : "False");
        stringBuffer.append("\r\n");
        stringBuffer.append("User Login Required = ");
        stringBuffer.append(this.loginRequired ? "True" : "False");
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    public String getPkcs11Identifier(String string) {
        if (string == null) {
            throw new IllegalArgumentException("PKCS11TokenInfo.getPkcs11Identifier(String) - The supplied String is null.");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(":");
        stringBuffer.append(this.stripDelimiters(this.getManufacturerID()));
        stringBuffer.append(":");
        stringBuffer.append(this.stripDelimiters(this.getModel()));
        return stringBuffer.toString();
    }

    private String stripDelimiters(String string) {
        return string.replace(',', ' ').replace(':', ' ').trim();
    }
}

