/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.asn1.a7;
import au.gov.bafcsi.clapi.asn1.ax;
import au.gov.bafcsi.clapi.asn1.az;
import au.gov.bafcsi.clapi.asn1.b1;
import au.gov.bafcsi.clapi.asn1.bm;
import au.gov.bafcsi.clapi.asn1.cf;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.asn1.dn;
import au.gov.bafcsi.clapi.common.AlgorithmIdentifier;
import au.gov.bafcsi.clapi.common.Attributes;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.crypto.CsiRsaPrivateKey;
import au.gov.bafcsi.clapi.crypto.DsaParameters;
import au.gov.bafcsi.clapi.crypto.Pkcs1EncodedRsaPrivateKey;
import au.gov.bafcsi.clapi.crypto.UnsupportedAlgorithmException;
import au.gov.bafcsi.clapi.crypto.fr;
import au.gov.bafcsi.common.ByteArray;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class Pkcs8EncodedPrivateKey
extends az {
    public Pkcs8EncodedPrivateKey() {
        this.a((ax)new a7(), "version");
        this.a((ax)new AlgorithmIdentifier(), "privateKeyAlgorithm");
        this.a((ax)new cf(), "privateKey");
        this.a((ax)new bm(new b1(new Attributes(), 0)), "attributes");
    }

    public Pkcs8EncodedPrivateKey(PrivateKey privateKey, Attributes attributes) throws IOException, CoderException {
        if (privateKey == null) {
            throw new IllegalArgumentException("Pkcs8EncodedPrivateKey(PrivateKey, Attributes) - PrivateKey is null.");
        }
        if (!privateKey.getAlgorithm().equals("RSA") && !privateKey.getAlgorithm().equals("DSA")) {
            throw new IllegalArgumentException("Pkcs8EncodedPrivateKey(PrivateKey, Attributes) - PrivateKey must be either RSA or DSA.");
        }
        this.a((ax)new a7(0L), "version");
        if (privateKey.getAlgorithm().equals("RSA")) {
            this.a((ax)new AlgorithmIdentifier((Oid)Oids.rsaEncryption, new dn()), "privateKeyAlgorithm");
            this.a((ax)new cf(new Pkcs1EncodedRsaPrivateKey((CsiRsaPrivateKey)privateKey, null).g()), "privateKey");
        } else {
            fr fr2 = (fr)privateKey;
            this.a((ax)new AlgorithmIdentifier((Oid)Oids.dsaANSI, (DsaParameters)fr2.getParams()), "privateKeyAlgorithm");
            this.a((ax)new cf(new a7(fr2.getX()).g()), "privateKey");
        }
        if (attributes == null || attributes.isEmpty()) {
            this.a((ax)new bm(new b1(new Attributes(), 0), false), "attributes");
        } else {
            this.a((ax)new bm(new b1(attributes, 0)), "attributes");
        }
    }

    public int getVersion() {
        return ((a7)this.a((String)"version")).a.intValue();
    }

    public Oid getAlgorithmOid() {
        return ((AlgorithmIdentifier)this.a("privateKeyAlgorithm")).getAlgorithmOID();
    }

    AlgorithmIdentifier getAlgorithmIdentifier() {
        return (AlgorithmIdentifier)this.a("privateKeyAlgorithm");
    }

    public ByteArray getPrivateKeyBytes() {
        return ((cf)this.a("privateKey")).j();
    }

    PrivateKey getPrivateKey() throws IOException, CoderException, NoSuchAlgorithmException, InvalidParameterSpecException {
        Oid oid = this.getAlgorithmOid();
        if (oid.equals(Oids.rsaEncryption) || oid.equals(Oids.rsa)) {
            Pkcs1EncodedRsaPrivateKey pkcs1EncodedRsaPrivateKey = new Pkcs1EncodedRsaPrivateKey();
            pkcs1EncodedRsaPrivateKey.a(((cf)this.a("privateKey")).j());
            return new CsiRsaPrivateKey(pkcs1EncodedRsaPrivateKey);
        }
        if (oid.equals(Oids.dsa) || oid.equals(Oids.dsaANSI)) {
            AlgorithmIdentifier algorithmIdentifier = this.getAlgorithmIdentifier();
            AlgorithmParameters algorithmParameters = algorithmIdentifier.getAlgorithmParameters();
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameters.getParameterSpec(DSAParameterSpec.class);
            a7 a72 = new a7();
            a72.a(((cf)this.a("privateKey")).j());
            return new fr(new DsaParameters(dSAParameterSpec), a72.a);
        }
        throw new UnsupportedAlgorithmException("Pkcs8EncodedPrivateKey.getPrivateKey() - The supplied key was neither a DSA, nor an RSA PrivateKey");
    }

    public Attributes getAttributes() {
        bm bm2 = (bm)this.a("attributes");
        if (bm2.a) {
            return (Attributes)bm2.getPrimitive();
        }
        return null;
    }
}

