/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto.provider;

import au.gov.bafcsi.clapi.crypto.CsiDsaParameters;
import au.gov.bafcsi.clapi.crypto.CsiIvParameters;
import au.gov.bafcsi.clapi.crypto.CsiPbeParameters;
import au.gov.bafcsi.clapi.crypto.CsiRc2Parameters;
import au.gov.bafcsi.clapi.crypto.CsiRsaKeyFactory;
import au.gov.bafcsi.clapi.crypto.DsaWithSha1SignatureSpi;
import au.gov.bafcsi.clapi.crypto.RsaCipherSpi;
import au.gov.bafcsi.clapi.crypto.RsaWithMd5SignatureSpi;
import au.gov.bafcsi.clapi.crypto.RsaWithSha1SignatureSpi;
import au.gov.bafcsi.clapi.crypto.RsaWithSha256SignatureSpi;
import au.gov.bafcsi.clapi.crypto.digest.g7;
import au.gov.bafcsi.clapi.crypto.digest.g9;
import au.gov.bafcsi.clapi.crypto.digest.hb;
import au.gov.bafcsi.clapi.crypto.digest.hc;
import au.gov.bafcsi.clapi.crypto.g4;
import au.gov.bafcsi.clapi.crypto.keygen.CsiRsaKeyPairGenerator;
import au.gov.bafcsi.clapi.crypto.keygen.g5;
import au.gov.bafcsi.clapi.crypto.mac.f8;
import au.gov.bafcsi.clapi.crypto.prng.CsiSecureRandom;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.Rc2;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.Rc2KeyFactory;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.Rijndael;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.RijndaelKeyFactory;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.RijndaelKeyGenerator;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.TripleDes;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.TripleDesKeyFactory;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.TripleDesKeyGenerator;
import java.security.Provider;
import java.security.Security;

public class CsiProvider
extends Provider {
    public static final String NAME = "CSIPROVIDER";
    public static final String SIGNATURE_NAME_RSA_WITH_SHA1 = "RSAwithSHA1";
    public static final String SIGNATURE_NAME_RSA_WITH_SHA256 = "RSAwithSHA256";
    public static final String SIGNATURE_NAME_RSA_WITH_MD5 = "RSAwithMD5";
    public static final String SIGNATURE_NAME_DSA_WITH_SHA1 = "DSAwithSHA1";
    public static final String CIPHER_NAME_RSA = "RSA";
    public static final String CIPHER_NAME_3DES = "3DES";
    public static final String CIPHER_NAME_AES = "AES";
    public static final String CIPHER_NAME_RC2 = "RC2";
    public static final String DIGEST_NAME_SHA1 = "SHA-1";
    public static final String DIGEST_NAME_SHA256 = "SHA-256";
    public static final String DIGEST_NAME_MD5 = "MD5";
    public static final String DIGEST_NAME_NULL = "Null";
    public static final String KEY_FACTORY_NAME_RSA = "RSA";
    public static final String KEY_FACTORY_NAME_DSA = "DSA";
    public static final String KEY_GENERATOR_NAME_3DES = "3DES";
    public static final String KEY_GENERATOR_NAME_AES = "AES";
    public static final String KEY_PAIR_GENERATOR_NAME_RSA = "RSA";
    public static final String KEY_PAIR_GENERATOR_NAME_DSA = "DSA";
    public static final String SECRET_KEY_FACTORY_NAME_3DES = "3DES";
    public static final String SECRET_KEY_FACTORY_NAME_AES = "AES";
    public static final String SECRET_KEY_FACTORY_NAME_RC2 = "RC2";
    public static final String SECURE_RANDOM_NAME_SHA1_PRNG = "PRNG";
    public static final String ALGORITHM_PARAMETERS_NAME_3DES_CBC = "3DES/CBC";
    public static final String ALGORITHM_PARAMETERS_NAME_AES = "AES";
    public static final String ALGORITHM_PARAMETERS_NAME_DSA = "DSA";
    public static final String ALGORITHM_PARAMETERS_NAME_IV = "IV";
    public static final String ALGORITHM_PARAMETERS_NAME_PBE = "PBE";
    public static final String ALGORITHM_PARAMETERS_NAME_RC2 = "RC2";
    public static final String MAC_NAME_HMAC_SHA1 = "HmacSha1";
    public static final String MAC_NAME_HMAC_MD5 = "HmacMd5";
    private static final double VERSION = 1.0;
    private static final String INFO = "Provides functionality for CSI cryptographic support.";
    private static CsiProvider m_csiProvider = null;

    public CsiProvider() {
        super(NAME, 1.0, INFO);
        this.put("Signature.RSAwithSHA1", "au.gov.bafcsi.clapi.crypto.RsaWithSha1SignatureSpi");
        this.put("Alg.Alias.Signature.RSAwithSHA-1", SIGNATURE_NAME_RSA_WITH_SHA1);
        this.put("Alg.Alias.Signature.SHA1withRSA", SIGNATURE_NAME_RSA_WITH_SHA1);
        this.put("Alg.Alias.Signature.SHA-1withRSA", SIGNATURE_NAME_RSA_WITH_SHA1);
        this.put("Alg.Alias.Signature.SHA-1/RSA/PKCS#1", SIGNATURE_NAME_RSA_WITH_SHA1);
        this.put("Signature.RSAwithSHA256", "au.gov.bafcsi.clapi.crypto.RsaWithSha256SignatureSpi");
        this.put("Alg.Alias.Signature.RSAwithSHA-256", SIGNATURE_NAME_RSA_WITH_SHA256);
        this.put("Alg.Alias.Signature.SHA256withRSA", SIGNATURE_NAME_RSA_WITH_SHA256);
        this.put("Alg.Alias.Signature.SHA-256withRSA", SIGNATURE_NAME_RSA_WITH_SHA256);
        this.put("Alg.Alias.Signature.SHA-256/RSA/PKCS#1", SIGNATURE_NAME_RSA_WITH_SHA256);
        this.put("Signature.RSAwithMD5", "au.gov.bafcsi.clapi.crypto.RsaWithMd5SignatureSpi");
        this.put("Alg.Alias.Signature.MD5withRSA", SIGNATURE_NAME_RSA_WITH_MD5);
        this.put("Alg.Alias.Signature.MD5/RSA/PKCS#1", SIGNATURE_NAME_RSA_WITH_MD5);
        this.put("Signature.RSAwithNULL", "au.gov.bafcsi.clapi.crypto.RsaWithNullSignatureSpi");
        this.put("Signature.DSAwithSHA1", "au.gov.bafcsi.clapi.crypto.DsaWithSha1SignatureSpi");
        this.put("Alg.Alias.Signature.DSAwithSHA-1", SIGNATURE_NAME_DSA_WITH_SHA1);
        this.put("Alg.Alias.Signature.SHA1withDSA", SIGNATURE_NAME_DSA_WITH_SHA1);
        this.put("Alg.Alias.Signature.SHA-1withDSA", SIGNATURE_NAME_DSA_WITH_SHA1);
        this.put("KeyFactory.RSA", "au.gov.bafcsi.clapi.crypto.CsiRsaKeyFactory");
        this.put("KeyFactory.DSA", "au.gov.bafcsi.clapi.crypto.g4");
        this.put("Cipher.RSA", "au.gov.bafcsi.clapi.crypto.RsaCipherSpi");
        this.put("KeyPairGenerator.RSA", "au.gov.bafcsi.clapi.crypto.keygen.CsiRsaKeyPairGenerator");
        this.put("KeyPairGenerator.DSA", "au.gov.bafcsi.clapi.crypto.keygen.g5");
        this.put("Cipher.TripleDES", "au.gov.bafcsi.clapi.crypto.symmetriccipher.TripleDes");
        this.put("Alg.Alias.Cipher.DESede", "TripleDES");
        this.put("Alg.Alias.Cipher.3DES", "TripleDES");
        this.put("Alg.Alias.Cipher.DES3", "TripleDES");
        this.put("KeyGenerator.TripleDES", "au.gov.bafcsi.clapi.crypto.symmetriccipher.TripleDesKeyGenerator");
        this.put("Alg.Alias.KeyGenerator.DESede", "TripleDES");
        this.put("Alg.Alias.KeyGenerator.3DES", "TripleDES");
        this.put("Alg.Alias.KeyGenerator.DES3", "TripleDES");
        this.put("SecretKeyFactory.TripleDES", "au.gov.bafcsi.clapi.crypto.symmetriccipher.TripleDesKeyFactory");
        this.put("Alg.Alias.SecretKeyFactory.DESede", "TripleDES");
        this.put("Alg.Alias.SecretKeyFactory.3DES", "TripleDES");
        this.put("Alg.Alias.SecretKeyFactory.DES3", "TripleDES");
        this.put("Cipher.AES", "au.gov.bafcsi.clapi.crypto.symmetriccipher.Rijndael");
        this.put("Alg.Alias.Cipher.Rijndael", "AES");
        this.put("KeyGenerator.AES", "au.gov.bafcsi.clapi.crypto.symmetriccipher.RijndaelKeyGenerator");
        this.put("Alg.Alias.KeyGenerator.Rijndael", "AES");
        this.put("SecretKeyFactory.AES", "au.gov.bafcsi.clapi.crypto.symmetriccipher.RijndaelKeyFactory");
        this.put("Alg.Alias.SecretKeyFactory.Rijndael", "AES");
        this.put("Cipher.RC2", "au.gov.bafcsi.clapi.crypto.symmetriccipher.Rc2");
        this.put("SecretKeyFactory.RC2", "au.gov.bafcsi.clapi.crypto.symmetriccipher.Rc2KeyFactory");
        this.put("MessageDigest.MD5", "au.gov.bafcsi.clapi.crypto.digest.g7");
        this.put("MessageDigest.SHA-1", "au.gov.bafcsi.clapi.crypto.digest.g9");
        this.put("Alg.Alias.MessageDigest.SHA1", DIGEST_NAME_SHA1);
        this.put("Alg.Alias.MessageDigest.SHA", DIGEST_NAME_SHA1);
        this.put("MessageDigest.SHA-256", "au.gov.bafcsi.clapi.crypto.digest.hb");
        this.put("Alg.Alias.MessageDigest.SHA256", DIGEST_NAME_SHA256);
        this.put("MessageDigest.Null", "au.gov.bafcsi.clapi.crypto.digest.hc");
        this.put("SecureRandom.PRNG", "au.gov.bafcsi.clapi.crypto.prng.CsiSecureRandom");
        this.put("Alg.Alias.SecureRandom.SHA1PRNG", SECURE_RANDOM_NAME_SHA1_PRNG);
        this.put("AlgorithmParameters.3DES/CBC", "au.gov.bafcsi.clapi.crypto.CsiIvParameters");
        this.put("Alg.Alias.AlgorithmParameters.DESede/CBC", ALGORITHM_PARAMETERS_NAME_3DES_CBC);
        this.put("Alg.Alias.AlgorithmParameters.TripleDES/CBC", ALGORITHM_PARAMETERS_NAME_3DES_CBC);
        this.put("Alg.Alias.AlgorithmParameters.3DES", ALGORITHM_PARAMETERS_NAME_3DES_CBC);
        this.put("Alg.Alias.AlgorithmParameters.DES3", ALGORITHM_PARAMETERS_NAME_3DES_CBC);
        this.put("Alg.Alias.AlgorithmParameters.DESede", ALGORITHM_PARAMETERS_NAME_3DES_CBC);
        this.put("Alg.Alias.AlgorithmParameters.TripleDES", ALGORITHM_PARAMETERS_NAME_3DES_CBC);
        this.put("AlgorithmParameters.AES", "au.gov.bafcsi.clapi.crypto.CsiIvParameters");
        this.put("Alg.Alias.AlgorithmParameters.Rijndael", "AES");
        this.put("Alg.Alias.AlgorithmParameters.AES/CBC", "AES");
        this.put("Alg.Alias.AlgorithmParameters.Rijndael/CBC", "AES");
        this.put("AlgorithmParameters.IV", "au.gov.bafcsi.clapi.crypto.CsiIvParameters");
        this.put("AlgorithmParameters.RC2", "au.gov.bafcsi.clapi.crypto.CsiRc2Parameters");
        this.put("AlgorithmParameters.DSA", "au.gov.bafcsi.clapi.crypto.CsiDsaParameters");
        this.put("AlgorithmParameters.PBE", "au.gov.bafcsi.clapi.crypto.CsiPbeParameters");
        this.put("Mac.HmacSHA1", "au.gov.bafcsi.clapi.crypto.mac.f8");
        this.put("Alg.Alias.Mac.HmacSHA-1", "HmacSHA1");
        this.put("Alg.Alias.Mac.HMACwithSHA1", "HmacSHA1");
        this.put("Alg.Alias.Mac.HMACwithSHA-1", "HmacSHA1");
        this.put("Alg.Alias.Mac.Hmac/SHA1", "HmacSHA1");
        this.put("Alg.Alias.Mac.Hmac/SHA-1", "HmacSHA1");
        this.put("Alg.Alias.Mac.HmacSHA", "HmacSHA1");
        this.put("Alg.Alias.Mac.HMACwithSHA", "HmacSHA1");
        this.put("Alg.Alias.Mac.Hmac/SHA", "HmacSHA1");
        this.put("Mac.HmacMD5", "au.gov.bafcsi.clapi.crypto.mac.HmacMd5");
        this.put("Alg.Alias.Mac.HMACwithMD5", "HmacMD5");
        this.put("Alg.Alias.Mac.Hmac/MD5", "HmacMD5");
    }

    public static void addCsiProvider() {
        if (m_csiProvider == null) {
            m_csiProvider = new CsiProvider();
        }
        if (Security.getProvider(NAME) == null) {
            Security.addProvider(m_csiProvider);
            CsiSecureRandom.class.getName();
        }
    }

    void hiddenReferenceFunction() {
        new RsaWithSha256SignatureSpi();
        new RsaWithSha1SignatureSpi();
        new RsaWithMd5SignatureSpi();
        new DsaWithSha1SignatureSpi();
        new CsiRsaKeyFactory();
        new g4();
        new RsaCipherSpi();
        new CsiRsaKeyPairGenerator();
        new g5();
        new CsiSecureRandom();
        new TripleDes();
        new TripleDesKeyGenerator();
        new TripleDesKeyFactory();
        new Rijndael();
        new RijndaelKeyGenerator();
        new RijndaelKeyFactory();
        new Rc2();
        new Rc2KeyFactory();
        new f8();
        new g7();
        new g9();
        new hb();
        new hc();
        new CsiIvParameters();
        new CsiRc2Parameters();
        new CsiDsaParameters();
        new CsiPbeParameters();
    }
}

