/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto.symmetriccipher;

import au.gov.bafcsi.clapi.crypto.symmetriccipher.df;

public final class TripleDesKeyGenerator
extends df {
    private static final int STRENGTH = 168;
    private static final int BIT_LEN = 192;

    public TripleDesKeyGenerator() {
        super("TripleDES", 168);
    }

    protected final boolean isWeak(byte[] byArray) {
        return false;
    }

    protected final boolean isValidSize(int n10) {
        return n10 == 168;
    }

    protected final int strengthToBits(int n10) {
        if (n10 != 168) {
            throw new RuntimeException("Invalid strength value (" + n10 + ")");
        }
        return 192;
    }

    protected final byte[] fixUp(byte[] byArray) {
        for (int i10 = 0; i10 < byArray.length; ++i10) {
            byte by2 = byArray[i10];
            byArray[i10] = (byte)(by2 & 0xFE | (by2 >> 1 ^ by2 >> 2 ^ by2 >> 3 ^ by2 >> 4 ^ by2 >> 5 ^ by2 >> 6 ^ by2 >> 7) & 1);
        }
        return byArray;
    }
}

