/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging;

import au.gov.bafcsi.clapi.asn1.bc;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.crypto.CertStoreException;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.crypto.UserCancelledSignatureException;
import au.gov.bafcsi.clapi.packaging.cms.full.SigningParameters;
import au.gov.bafcsi.clapi.packaging.cms.full.cc;
import au.gov.bafcsi.clapi.packaging.cms.full.ct;
import au.gov.bafcsi.clapi.packaging.exceptions.BadMessageFormatException;
import au.gov.bafcsi.clapi.packaging.exceptions.PackagingException;
import au.gov.bafcsi.clapi.packaging.xml.XMLException;
import au.gov.bafcsi.clapi.packaging.xml.signature.XMLSignature;
import au.gov.bafcsi.clapi.packaging.xml.signature.c14n.hf;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.MimeType;
import au.gov.bafcsi.common.UserCancelledIOException;
import au.gov.bafcsi.common.utils.base64.Base64OutputStream;
import au.gov.bafcsi.common.utils.s;
import au.gov.bafcsi.hapi.PackageFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class NonRepudiationSign {
    public static ByteArray sign(CsiCertificate csiCertificate, byte[] byArray, PackageFormat packageFormat) throws IOException {
        return NonRepudiationSign.sign(csiCertificate, byArray, packageFormat, MimeType.PLAIN_TEXT);
    }

    public static ByteArray sign(CsiCertificate csiCertificate, byte[] byArray, PackageFormat packageFormat, MimeType mimeType) throws IOException {
        if (csiCertificate == null) {
            throw new IllegalArgumentException("NonRepudiationSign : CsiCertificate is null.");
        }
        if (!csiCertificate.canDoNonRepudiationSigning()) {
            throw new IllegalArgumentException("NonRepudiationSign : CsiCertificate cannot do NonRepudiation signing.");
        }
        if (packageFormat == null) {
            throw new IllegalArgumentException("NonRepudiationSign : PackageFormat is null.");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("NonRepudiationSign : ByteArray is null.");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("NonRepudiationSign : ByteArray is empty.");
        }
        if (mimeType == null) {
            throw new IllegalArgumentException("NonRepudiationSign: MimeType is null.");
        }
        if (s.a().an()) {
            throw new UnsupportedOperationException("Cannot sign for non-repudiation when running the CSI in server mode.");
        }
        ByteArray byteArray = packageFormat.equals(PackageFormat.XML) ? NonRepudiationSign.doRegularXmlSignature(csiCertificate, byArray, mimeType) : NonRepudiationSign.doRegularCmsSignature(csiCertificate, byArray, mimeType);
        if (packageFormat.equals(PackageFormat.CMS)) {
            return byteArray;
        }
        if (packageFormat.equals(PackageFormat.SMIME)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Content-Type: application/pkcs7-mime; smime-type=signed-data; name=smime.p7m\r\n");
            stringBuffer.append("Content-Transfer-Encoding: base64\r\n");
            stringBuffer.append("Content-Disposition: attachment; filename=smime.p7m\r\n");
            stringBuffer.append("\r\n");
            byteArrayOutputStream.write(stringBuffer.toString().getBytes());
            Base64OutputStream base64OutputStream = new Base64OutputStream(byteArrayOutputStream);
            base64OutputStream.write(byteArray.getBytes());
            base64OutputStream.flush();
            byteArrayOutputStream.flush();
            return new ByteArray(byteArrayOutputStream.toByteArray());
        }
        if (packageFormat.equals(PackageFormat.XML)) {
            return byteArray;
        }
        throw new IllegalArgumentException("Unknown package format");
    }

    private static ByteArray doRegularCmsSignature(CsiCertificate csiCertificate, byte[] byArray, MimeType mimeType) throws IOException {
        ByteArray byteArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            SigningParameters signingParameters = new SigningParameters(csiCertificate);
            signingParameters.setNonRepudiationIsIntended(true);
            signingParameters.setMimeType(mimeType);
            ct ct2 = new ct(signingParameters);
            cc cc2 = new cc(Oids.signedData, ct2);
            bc bc2 = cc2.encode(byteArrayOutputStream);
            OutputStream outputStream = ct2.n();
            outputStream.write(byArray);
            ct2.o();
            cc2.e();
            bc2.flush();
            byteArray = new ByteArray(byteArrayOutputStream.toByteArray());
        }
        catch (CertStoreException certStoreException) {
            throw new PackagingException("Unexpected CertStoreException.", certStoreException);
        }
        catch (CoderException coderException) {
            throw new BadMessageFormatException("Unexpected CoderException.", coderException);
        }
        return byteArray;
    }

    private static ByteArray doRegularXmlSignature(CsiCertificate csiCertificate, byte[] byArray, MimeType mimeType) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            XMLSignature xMLSignature;
            try {
                xMLSignature = XMLSignature.buildEnveloped(new ByteArray(byArray), csiCertificate, true, "CSISignature", mimeType);
            }
            catch (UserCancelledSignatureException userCancelledSignatureException) {
                throw new UserCancelledIOException(userCancelledSignatureException.getMessage(), userCancelledSignatureException);
            }
            hf hf2 = new hf("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
            hf2.a(xMLSignature.getElement(), (OutputStream)byteArrayOutputStream);
        }
        catch (XMLException xMLException) {
            throw new IOException("NonRepudiationSign.doRegularXmlSignature(CsiCertificate, byte[]) - " + xMLException.toString());
        }
        return new ByteArray(byteArrayOutputStream.toByteArray());
    }
}

