/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.cms.full;

import au.gov.bafcsi.clapi.asn1.a7;
import au.gov.bafcsi.clapi.asn1.ax;
import au.gov.bafcsi.clapi.asn1.az;
import au.gov.bafcsi.clapi.asn1.b1;
import au.gov.bafcsi.clapi.asn1.bh;
import au.gov.bafcsi.clapi.asn1.bm;
import au.gov.bafcsi.clapi.asn1.bv;
import au.gov.bafcsi.clapi.asn1.cf;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.asn1.dn;
import au.gov.bafcsi.clapi.certs.bx;
import au.gov.bafcsi.clapi.common.AlgorithmIdentifier;
import au.gov.bafcsi.clapi.common.Attribute;
import au.gov.bafcsi.clapi.common.Attributes;
import au.gov.bafcsi.clapi.common.DigestOid;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.crypto.CertificateStore;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.crypto.CsiPrivateKey;
import au.gov.bafcsi.clapi.crypto.UserCancelledSignatureException;
import au.gov.bafcsi.clapi.packaging.cms.full.CsiInformation;
import au.gov.bafcsi.clapi.packaging.cms.full.Identifier;
import au.gov.bafcsi.clapi.packaging.cms.full.SMimeCapabilities;
import au.gov.bafcsi.clapi.packaging.cms.full.SMimeEncryptionKeyPreference;
import au.gov.bafcsi.clapi.packaging.cms.full.SigningParameters;
import au.gov.bafcsi.clapi.packaging.exceptions.BadMessageFormatException;
import au.gov.bafcsi.clapi.packaging.exceptions.PackagingException;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.UserCancelledIOException;
import au.gov.bafcsi.common.utils.q;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.Date;

public final class SignerInfo
extends az {
    private static final String idVersion = "version";
    private static final String idSignerId = "signerIdentifier";
    private static final String idDigestAlg = "digestAlgorithm";
    private static final String idSignedAttrs = "signedAttributes";
    private static final String idSigAlg = "signatureAlgorithm";
    private static final String idSignature = "signatureValue";
    private static final String idUnsignedAttrs = "unsignedAttributes";
    private boolean verifyStatus = false;

    public SignerInfo() {
        r.a(w.j, "Decoding CMS");
        Attribute.addMapping(Oids.contentType, bh.class);
        Attribute.addMapping(Oids.signingTime, bx.class);
        Attribute.addMapping(Oids.messageDigest, cf.class);
        Attribute.addMapping(Oids.counterSignature, SignerInfo.class);
        Attribute.addMapping(Oids.smimeCapabilities, SMimeCapabilities.class);
        Attribute.addMapping(Oids.smimeEncrypKeyPref, SMimeEncryptionKeyPreference.class);
        Attribute.addMapping(Oids.csiSigningInformation, CsiInformation.class);
        this.a((ax)new a7(), idVersion);
        this.a((ax)new Identifier(), idSignerId);
        this.a((ax)new AlgorithmIdentifier(), idDigestAlg);
        this.a((ax)new bm(new b1(new Attributes(), 0)), idSignedAttrs);
        this.a((ax)new AlgorithmIdentifier(), idSigAlg);
        this.a((ax)new cf(), idSignature);
        this.a((ax)new bm(new b1(new Attributes(), 1)), idUnsignedAttrs);
    }

    public SignerInfo(SigningParameters signingParameters, Signature signature) throws IOException {
        if (signature == null) {
            throw new IllegalArgumentException("SignerInfo(SigningParameters,Signature) : Signature is null.");
        }
        if (signingParameters == null) {
            throw new IllegalArgumentException("SignerInfo(SigningParameters,Signature) : SigningParameters is null.");
        }
        if (!signingParameters.hasSignedAttributes()) {
            throw new IllegalArgumentException("SignerInfo(SigningParameters,Signature) : There are no signed Attributes present.");
        }
        r.a(w.j, "Encoding CMS");
        try {
            this.a((ax)new a7(1L), idVersion);
            this.a((ax)new Identifier(signingParameters.getSigningCertificate()), idSignerId);
            this.a((ax)new AlgorithmIdentifier(signingParameters.getDigestAlgorithm(), new dn()), idDigestAlg);
            byte[] byArray = signature.sign();
            r.a(w.j, "Signature bytes:\n" + new ByteArray(byArray).toHexString());
            Attributes attributes = signingParameters.getSignedAttributes();
            if (attributes == null) {
                throw new PackagingException("SignerInfo(SigningParameters,Signature) : Signed Attributes are null.");
            }
            this.a((ax)new bm(new b1(attributes, 0)), idSignedAttrs);
            try {
                r.a(w.j, "Signed attributes:\n" + attributes.g().toHexString());
            }
            catch (CoderException coderException) {
                // empty catch block
            }
            CertificateStore certificateStore = CertificateStore.getInstance();
            CsiPrivateKey csiPrivateKey = certificateStore.getPrivateKey(signingParameters.getSigningCertificate());
            String string = csiPrivateKey.getAlgorithm();
            Oid oid = string.equals("RSA") ? Oids.rsaEncryption : Oids.dsa;
            this.a((ax)new AlgorithmIdentifier(oid, new dn()), idSigAlg);
            csiPrivateKey = null;
            this.a((ax)new cf(byArray), idSignature);
            if (signingParameters.hasUnsignedAttributes()) {
                this.a((ax)new bm(new b1(signingParameters.getUnsignedAttributes(), 1)), idUnsignedAttrs);
            } else {
                this.a((ax)new bm(null, false), idUnsignedAttrs);
            }
        }
        catch (CertificateException certificateException) {
            throw new PackagingException("Unexpected CertificateException.", certificateException);
        }
        catch (SignatureException signatureException) {
            if (signatureException instanceof UserCancelledSignatureException) {
                throw new UserCancelledIOException("User Cancelled.", signatureException, ((UserCancelledSignatureException)signatureException).getInvalidPasswordAttempts());
            }
            throw new PackagingException("Unexpected SignatureException.", signatureException);
        }
    }

    public boolean verifyDigest(ByteArray byteArray, CsiCertificate csiCertificate) throws IOException {
        if (csiCertificate == null) {
            throw new IllegalArgumentException("SignerInfo.verifyDigest(ByteArray,CsiCertificate) : CsiCertificate is null");
        }
        if (byteArray == null) {
            throw new IllegalArgumentException("SignerInfo.verifyDigest(ByteArray,CsiCertificate) : ByteArray is null.");
        }
        byte[] byArray = byteArray.getBytes();
        if (byArray.length == 0) {
            throw new IllegalArgumentException("SignerInfo.verifyDigest(ByteArray,CsiCertificate) : ByteArray length is 0.");
        }
        try {
            AlgorithmIdentifier algorithmIdentifier = this.getDigestAlgorithm();
            String string = Oids.getJCAMapping(algorithmIdentifier.getAlgorithmOID());
            if (byArray.length != DigestOid.getInstance(algorithmIdentifier.getAlgorithmOID()).getDigestLength()) {
                throw new IllegalArgumentException("SignerInfo.verifyDigest(ByteArray,CsiCertificate) : Invalid digest (" + string + ") supplied.");
            }
            AlgorithmIdentifier algorithmIdentifier2 = this.getSignatureAlgorithm();
            String string2 = Oids.getJCAMapping(algorithmIdentifier2.getAlgorithmOID());
            Attributes attributes = this.getSignedAttributes();
            if (attributes != null) {
                attributes.decodeFully();
                attributes.setImplicitlyWrapped(false);
                ByteArray byteArray2 = attributes.g();
                r.a(w.j, "Encoded attributes: " + byteArray2.toHexString());
                Signature signature = q.d(string + "with" + string2);
                signature.initVerify(csiCertificate);
                signature.update(byteArray2.getBytes());
                attributes.setImplicitlyWrapped(true);
                ByteArray byteArray3 = this.getSignature();
                r.a(w.j, "Signature bytes:\n" + byteArray3.toHexString());
                boolean bl2 = signature.verify(byteArray3.getBytes());
                r.a(w.j, "Signature valid: " + bl2);
                if (bl2) {
                    Attribute attribute = attributes.getAttribute(Oids.messageDigest);
                    if (attribute == null) {
                        throw new PackagingException("SignerInfo.verifyDigest(ByteArray,CsiCertificate) : The signed attributes do not contain a messageDigest attribute. This is illegal CMS syntax.");
                    }
                    ByteArray byteArray4 = ((cf)attribute.getFirstAttributeValue()).j();
                    r.a(w.j, "Decoded digest:    " + byteArray4.toHexString());
                    r.a(w.j, "Calculated digest: " + byteArray.toHexString());
                    this.verifyStatus = bl2 & byteArray.equals(byteArray4);
                    r.a(w.j, "Digest Valid: " + this.verifyStatus);
                } else {
                    this.verifyStatus = false;
                }
            } else {
                r.a(w.j, "Calculated digest: " + byteArray.toHexString());
                Signature signature = q.d(string2 + "withNULL");
                signature.initVerify(csiCertificate);
                signature.update(byteArray.getBytes());
                ByteArray byteArray5 = this.getSignature();
                r.a(w.j, "Signature bytes:\n" + byteArray5.toHexString());
                this.verifyStatus = signature.verify(byteArray5.getBytes());
            }
            return this.verifyStatus;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PackagingException("SignerInfo.verifyDigest(byte[],CsiCertificate) : " + invalidKeyException.getMessage(), invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw new PackagingException("SignerInfo.verifyDigest(byte[],CsiCertificate) : " + signatureException.getMessage(), signatureException);
        }
        catch (CoderException coderException) {
            throw new BadMessageFormatException("SignerInfo.verifyDigest(byte[],CsiCertificate) : " + coderException.getMessage(), coderException);
        }
    }

    public CsiInformation getCsiInformation() {
        Attributes attributes = this.getSignedAttributes();
        if (attributes == null) {
            return null;
        }
        Attribute attribute = attributes.getAttribute(Oids.csiSigningInformation);
        if (attribute == null) {
            return null;
        }
        return (CsiInformation)attribute.getFirstAttributeValue();
    }

    public int getVersion() {
        return ((a7)this.a((String)idVersion)).a.intValue();
    }

    public Identifier getIdentifier() {
        return (Identifier)this.a(idSignerId);
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return (AlgorithmIdentifier)this.a(idDigestAlg);
    }

    public Attributes getSignedAttributes() {
        bm bm2 = (bm)this.a(idSignedAttrs);
        if (bm2.a) {
            return (Attributes)bm2.getPrimitive();
        }
        return null;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return (AlgorithmIdentifier)this.a(idSigAlg);
    }

    public ByteArray getSignature() {
        return ((cf)this.a(idSignature)).j();
    }

    public Attributes getUnsignedAttributes() {
        bm bm2 = (bm)this.a(idUnsignedAttrs);
        if (bm2.a) {
            return (Attributes)bm2.getPrimitive();
        }
        return null;
    }

    public boolean getVerifyStatus() {
        return this.verifyStatus;
    }

    public Date getSigningTime() {
        Date date = null;
        Attributes attributes = this.getSignedAttributes();
        if (attributes != null && attributes.contains(Oids.signingTime)) {
            bx bx2 = (bx)attributes.getAttribute(Oids.signingTime).getFirstAttributeValue();
            date = ((bv)bx2.d()).b.getTime();
        }
        return date;
    }
}

