/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.xml;

import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.crypto.UserCancelledSignatureException;
import au.gov.bafcsi.clapi.packaging.SignedOutputStream;
import au.gov.bafcsi.clapi.packaging.xml.XMLException;
import au.gov.bafcsi.clapi.packaging.xml.XMLSerializer;
import au.gov.bafcsi.clapi.packaging.xml.signature.XMLSignature;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.UserCancelledIOException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SignedXMLOutputStream
extends SignedOutputStream {
    private OutputStream out;
    private ByteArrayOutputStream bytes;
    private CsiCertificate certificate;
    private boolean nonRepudiation;

    public SignedXMLOutputStream(OutputStream outputStream, CsiCertificate csiCertificate, boolean bl2) {
        if (outputStream == null) {
            throw new IllegalArgumentException("SignedXMLOutputStream(OutputStream, CsiCertificate, boolean) - The supplied OutputStream is null.");
        }
        if (csiCertificate == null) {
            throw new IllegalArgumentException("SignedXMLOutputStream(OutputStream, CsiCertificate, boolean) - The supplied CsiCertificate is null.");
        }
        if (bl2 && !csiCertificate.canDoNonRepudiationSigning()) {
            throw new IllegalArgumentException("SignedXMLOutputStream(OutputStream, CsiCertificate, boolean) - The supplied CsiCertificate cannot sign for non repudiation.");
        }
        if (!csiCertificate.canDoAuthenticationSigning()) {
            throw new IllegalArgumentException("SignedXMLOutputStream(OutputStream, CsiCertificate, boolean) - The supplied CsiCertificate cannot sign for authentication.");
        }
        this.out = outputStream;
        this.certificate = csiCertificate;
        this.bytes = new ByteArrayOutputStream();
        this.nonRepudiation = bl2;
    }

    public void write(int n10) throws IOException {
        if (this.bytes == null) {
            throw new IOException("SignedXMLOutputStream.write(int) - The OutputStream has been closed !");
        }
        this.bytes.write(n10);
    }

    public void close() throws IOException {
        if (this.bytes == null) {
            throw new IOException("SignedXMLOutputStream.close() - The OutputStream is already closed !");
        }
        try {
            XMLSignature xMLSignature;
            try {
                xMLSignature = XMLSignature.buildEnveloped(new ByteArray(this.bytes.toByteArray()), this.certificate, this.nonRepudiation, "CSISignature");
            }
            catch (UserCancelledSignatureException userCancelledSignatureException) {
                throw new UserCancelledIOException(userCancelledSignatureException.getMessage(), userCancelledSignatureException);
            }
            XMLSerializer.serialize(xMLSignature.getOwnerDocument(), this.out);
        }
        catch (XMLException xMLException) {
            throw new IOException("SignedXMLOutputStream.close() - " + xMLException.toString());
        }
        this.bytes = null;
    }

    public void setCancelled() {
    }
}

