/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.common.utils.base64;

import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.base64.Base64;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class Base64InputStream
extends FilterInputStream {
    private static final int END_OF_STREAM = -1;
    private static final int NO_DATA = -1;
    private static final int MAX_LINE_LENGTH = 76;
    private boolean encode;
    private int srcIndex;
    private int lineLength;
    private byte[] srcBuffer;
    private byte[] destBuffer;
    int numberBytes;
    boolean finished;
    boolean emptyOutput;

    public Base64InputStream(InputStream inputStream) {
        this(inputStream, false);
    }

    public Base64InputStream(InputStream inputStream, boolean bl2) {
        super(inputStream);
        this.encode = bl2;
        this.srcBuffer = new byte[bl2 ? 3 : 4];
        this.destBuffer = new byte[bl2 ? 4 : 3];
        this.srcIndex = -1;
        this.lineLength = 0;
        this.finished = false;
    }

    public int read() throws IOException {
        int n10;
        if (this.finished && this.emptyOutput) {
            return -1;
        }
        if (this.srcIndex == -1) {
            this.numberBytes = 0;
            if (this.encode) {
                for (n10 = 0; n10 < 3; ++n10) {
                    try {
                        int n11 = this.in.read();
                        if (n11 == -1) {
                            this.finished = true;
                            break;
                        }
                        this.srcBuffer[n10] = (byte)n11;
                        ++this.numberBytes;
                        continue;
                    }
                    catch (IOException iOException) {
                        if (n10 != 0) continue;
                        throw iOException;
                    }
                }
                if (this.numberBytes > 0) {
                    Base64.base64Encode(this.srcBuffer, 0, this.numberBytes, this.destBuffer, 0);
                    this.numberBytes = 4;
                    this.srcIndex = 0;
                    this.emptyOutput = false;
                }
            } else {
                for (n10 = 0; n10 < 4; ++n10) {
                    int n12;
                    while ((n12 = this.in.read()) >= 0 && (Base64.base64Decode[n12 & 0x7F] == -3 || Base64.base64Decode[n12 & 0x7F] == -2)) {
                    }
                    if (n12 == -1) {
                        this.finished = true;
                        break;
                    }
                    this.srcBuffer[n10] = (byte)n12;
                }
                if (n10 == 4) {
                    this.numberBytes = Base64.base64Decode(this.srcBuffer, 0, this.destBuffer, 0);
                    this.srcIndex = 0;
                    this.emptyOutput = false;
                }
            }
        }
        if (this.srcIndex == -1) {
            return -1;
        }
        if (this.srcIndex >= this.numberBytes) {
            return -1;
        }
        n10 = this.destBuffer[this.srcIndex++] << 24;
        n10 >>>= 24;
        if (this.srcIndex >= (this.encode ? 4 : 3)) {
            this.srcIndex = -1;
            this.emptyOutput = true;
        }
        ++this.lineLength;
        if (this.encode && this.lineLength >= 76) {
            this.destBuffer[2] = Base64.NEW_LINE[0];
            this.destBuffer[3] = Base64.NEW_LINE[1];
            this.srcIndex = 2;
            this.lineLength = -2;
        }
        return n10;
    }

    public int read(byte[] byArray, int n10, int n11) throws IOException {
        int n12;
        if (this.finished) {
            return -1;
        }
        for (n12 = 0; n12 < n11; ++n12) {
            int n13 = this.read();
            if (n13 == -1) {
                this.finished = true;
                return n12;
            }
            byArray[n10 + n12] = (byte)n13;
        }
        return n12;
    }

    public int read(ByteArray byteArray) throws IOException {
        if (this.finished) {
            return -1;
        }
        while (true) {
            int n10;
            if ((n10 = this.read()) == -1) {
                this.finished = true;
                return byteArray.length();
            }
            byteArray.append((byte)n10);
        }
    }
}

