if (typeof require === "function") {
    Q = require("./q");
}

function doXAsync() {
    return Q.resolve(5);
}

function doYAsync() {
    return doXAsync().then(function doXAsyncCallback() {
        return Q.delay(10).then(function delayCallback() {
            return { foo: "bar" };
        }).get("bar").then(function getBarCallback() {
            throw new Error("boo!");
        });
    });
}

function doZAsync() {
    return doYAsync();
}



//doZAsync()
//    .done();

function doA() {
    return Q.resolve("A");
}

function doB() {
    return Q.resolve("B");
}

function doC() {
    return Q.resolve("C");
}


function doABC() {
    var aPromise = doA().then(function aFulfillment() {
        var bPromise = doB().then(function bFulfillment() {
            var cPromise = doC().then(function cFulfillment() {
                throw new Error("boo!");
            });

            cPromise.name = "c";

            return cPromise;
        });

        bPromise.name = "b";

        return bPromise;
    });

    aPromise.name = "a";

    return aPromise;
}

Q.longStackJumpLimit = 2;

doABC().catch(function (e) {
    console.log(e.stack);
});

// first: a becomes b: a.source = b
// then: b becomes c: b.source = c
// a -> b -> c

// stack is: error ~ c ~ b ~ a

// so: a.catch(...), where a is rejected, means we call makeStackTraceLong(error, a)
// i think we're going to have to cut out things in the middle

// or we could do bidirectional links: a.source = b <-> b.sink = a
// then b.source = c <-> c.sink = b, but oh no, b.sink = a, and that's more than two levels, better kill the chain?
// what about if they just take b?
// hmm this is generally an issue. memory leaks and such.
// i guess the problem is holding on to elements of the chain forever.

// no! bidirectional is no good. you can resolve two promises to the same source, i.e. dfdA.resolve(b) and dfdX.resolve(b).

