"""
Initialises the interface for sudoku.

Copyright 2011 Bianca Gibson - bianca.rachel.gibson@gmail.com

	This file is part of Sudoku.

    Sudoku is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Sudoku is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Sudoku.  If not, see <http://www.gnu.org/licenses/>.
    
"""

#from will:
#TODO: put in other patterns
#WATCH OUT: add value returns an exceptiono if add value to the same cell-one wint something 
# already in it, only possible when in different rep
#handle exception on add value

#known bugs:  UNHIGHLIGHT errors in other reps and when change rep

#needs testing:
#				proper patterns testing(that boxes highlight properly), check solution(check method from console version is tested), 

#TODO:	make new button make a new puzzle-relies on back end connecting to generation first

import gtk, gobject, pygtk, sudoku_console, Sudoku, widgets, math

class  Interface:
	"""Sets up the interface for the sudoku. When initialised reads in in the glade file, displays it, 
	and sets up the events of objects in the glade file"""
	
	#make a new puzzle
	def new(self, widget, data = None):
		print "New"
		self.sudoku = sudoku_console.generateNewPuzzle()
		self.fillGui()
		self.fillPossible()
		self.grid.unhighlight_squares()
		self.highlightErrors()
		self.highlightPatterns()
		
	#open a puzzle from file
	def open(self, widget, data = None):
		"""opens the file chooser dialog"""
		print "open"
		
		#set up the file chooser dialog
		dialog = gtk.FileChooserDialog("Open..", None, gtk.FILE_CHOOSER_ACTION_OPEN, 
										(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL, gtk.STOCK_OPEN, gtk.RESPONSE_OK))
		#set the default response and run the dialog
		dialog.set_default_response(gtk.RESPONSE_OK)
		response = dialog.run()
		
		#act on the response
		if response == gtk.RESPONSE_OK:
			print dialog.get_filename(), ' selected'
			self.filename = dialog.get_filename()
			self.sudoku = sudoku_console.loadPuzzleFromPath(self.filename)
			self.fillGui()
		elif response == gtk.RESPONSE_CANCEL:
			print 'Closed, no files selected'
		dialog.destroy()
		
		self.fillPossible()
		self.grid.unhighlight_squares()
		self.highlightPatterns()
		self.highlightErrors()
		
		
	def fillGui(self):
		print 'fill gui'
		self.clearUserEntry()
		for row in range(self.sudoku.SIZE):
			for column in range(self.sudoku.SIZE):
				b = self.grid.__entries__[row][column]
				b.set_read_only(False)
				b.set_text(str(self.sudoku.puzzle[row][column]))
				#print self.sudoku.puzzle[row][column]
				#b.set_read_only(True)
				
	def fillPossible(self):
		self.sudoku.findPossiblePuzzle()
		for row in range(self.sudoku.SIZE):
			for column in range(self.sudoku.SIZE):
				b = self.grid.__entries__[row][column]
				possibilities = ""
				possibilitiesList = self.sudoku.getPossibilities(row, column)
				for item in range(len(possibilitiesList)):
					possibilities = possibilities + possibilitiesList[item]
				b.set_possibilities_text(self.sudoku.getPossibilities(row, column))
				
	def highlightPatterns(self):
		#highlight the single positions
		singlePositions = self.sudoku.findSinglePosition()
		for e in singlePositions:
			#make all the single posititions green
			self.grid.__entries__[e[0]][e[1]].set_background_color((0.0,0.75,0.0))
		
		#highlight single candidates second-overwrites where a square is both
		singleCandidates = self.sudoku.findSingleCandidate()
		for e in singleCandidates:
			#make all the single candidates blue
			self.grid.__entries__[e[0]][e[1]].set_background_color((0.0,0.0,1.0))
			
		nakedPair = self.sudoku.findNakedPair()
		for e in nakedPair:
			self.grid.__entries__[e[0]][e[1]].set_background_color((0.5,0.3,0.2))
			self.grid.__entries__[e[2]][e[3]].set_background_color((0.5,0.3,0.2))
			
		nakedTriple = self.sudoku.findNakedTriple()
		for e in nakedTriple:
			self.grid.__entries__[e[0]][e[1]].set_background_color((0.5,0.0,0.5))
			self.grid.__entries__[e[2]][e[3]].set_background_color((0.5,0.0,0.5))
			self.grid.__entries__[e[4]][e[5]].set_background_color((0.5,0.0,0.5))
			
		hiddenPair = self.sudoku.findHiddenPair()
		for e in hiddenPair:
			self.grid.__entries__[e[0]][e[1]].set_background_color((0.4,0.4,0.0))
			self.grid.__entries__[e[2]][e[3]].set_background_color((0.4,0.4,0.0))
			
		#hiddenTriple = self.sudoku.findHiddenTriple()
		#for e in hiddenTriple:
		#	self.grid.__entries__[e[0]][e[1]].set_background_color((0.4,0.0,0.4))
		#	self.grid.__entries__[e[2]][e[3]].set_background_color((0.4,0.0,0.4))
		#	self.grid.__entries__[e[4]][e[5]].set_background_color((0.4,0.0,0.4))
			
		#xWing = self.sudoku.findXWing()
		#for e in xWing:
		#	self.grid.__entries__[e[0]][e[1]].set_background_color((1.0,0.0,0.0))
		#	self.grid.__entries__[e[2]][e[3]].set_background_color((1.0,0.0,0.0))
		#	self.grid.__entries__[e[4]][e[5]].set_background_color((1.0,0.0,0.0))
		#	self.grid.__entries__[e[6]][e[7]].set_background_color((1.0,0.0,0.0))
		
		
			
	#def clearHighlight(self):
	#	for row in range(self.sudoku.SIZE):
	#		for column in range(self.sudoku.SIZE):
	#			b = self.grid.__entries__[row][column]
	#			#if not (b.read_only):
	#			#b.do_expose_event()
	#			b.set_background_color(None)
				
				
	#save progress
	def save(self, widget, data = None):
		print "save"
		self.sudoku.savePuzzle(self.filename)
		
	#save progress as
	def saveAs(self, widget, data = None):
		print "save as"
		
		#set up the file chooser dialog
		dialog = gtk.FileChooserDialog("Open..", None, gtk.FILE_CHOOSER_ACTION_SAVE, 
										(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL, gtk.STOCK_SAVE, gtk.RESPONSE_OK))
		#set the default response and run the dialog
		dialog.set_default_response(gtk.RESPONSE_OK)
		response = dialog.run()
		
		#act on the response
		if response == gtk.RESPONSE_OK:
			print dialog.get_filename(), ' selected'
			self.filename = dialog.get_filename()
			self.sudoku.savePuzzle(self.filename)
		elif response == gtk.RESPONSE_CANCEL:
			print 'Closed, no files selected'
		dialog.destroy()
		
		
	#displays an about dialog box
	#TODO: Link click event of close button in dialog box to destroy
	def about(self, widget, data = None):
		"""opens the about dialog"""
	
		#print about to keep track of what the user is doing
		print "about"
		
		filename = "sudoku_gui.glade"
		builder = gtk.Builder()
		builder.add_from_file(filename)
		builder.connect_signals(self)
		openDialog = builder.get_object('about_Sudoku')
		openDialog.run()
		openDialog.destroy()

	#clear the user entry
	def clear(self, widget, data = None):
		print "clear"
		self.grid.unhighlight_squares()
		self.clearUserEntry()
		
	
	#change representation to row-col
	def rowCol(self, widget, data = None):
		print "rowCol"
		self.sudoku.changeRepMode(1)
		#self.clearUserEntry()
		self.fillGui()
		self.fillPossible()
		self.grid.unhighlight_squares()
		self.highlightPatterns()
		self.highlightErrors()
		
	#change the representation to row-num
	def rowNum(self, widget, data = None):
		print "rowNum"
		self.sudoku.changeRepMode(2)
		#self.clearUserEntry()
		self.fillGui()
		self.fillPossible()
		self.grid.unhighlight_squares()
		self.highlightPatterns()
		self.highlightErrors()
		
	#set the representation to num-col
	def numCol(self, widget, data = None):
		print "numCol"
		self.sudoku.changeRepMode(3)
		#self.clearUserEntry()
		self.fillGui()
		self.fillPossible()
		self.grid.unhighlight_squares()
		self.highlightPatterns()
		self.highlightErrors()
		
	def clearUserEntry(self):
		for row in range(self.sudoku.SIZE):
			for column in range(self.sudoku.SIZE):
				b = self.grid.__entries__[row][column]
				#print type(self.grid)
				#print type(b)
				#if not (b.read_only):
				b.set_text("")
				b.set_possibilities_text("")
					
					
	def isComplete(self):
		if self.sudoku.checkPuzzle().__len__() == 0:
			return self.sudoku.isComplete()
		#return (self.sudoku.checkPuzzle().__len__() == 0)
		return False
		#return self.sudoku.isComplete()
			
	#check if it is complete
	def isCompleteCallback(self, widget, data = None):
		print "is complete?"
		if self.isComplete():
			dialog = gtk.Dialog("Victory!", None, 0, (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))
			label = gtk.Label("Victory is yours!")
			dialog.vbox.pack_start(label, True, True, 0)
			label.show()
			dialog.resize(200, 100)
			dialog.run()
			dialog.destroy()
		else:
			dialog = gtk.Dialog("Not complete", None, 0, (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))
			label = gtk.Label("The puzzle is not correct")
			dialog.vbox.pack_start(label, True, True, 0)
			label.show()
			dialog.resize(200, 100)
			dialog.run()
			dialog.destroy()
			
		
	#when a value in a box is changed
	def changed_callback(self, widget):
		#print "widget changed"
		if (widget.text == ""):
			self.sudoku.deleteValue(widget.x, widget.y)
		else:
			self.sudoku.addValue(widget.x, widget.y, int(widget.text))
					
		#get new possibilities
		self.sudoku.findPossiblePuzzle()
		
		#for row in range(self.sudoku.SIZE):
		#	for column in range(self.sudoku.SIZE):
		#		b = self.grid.__entries__[row][column]
		#		b.set_possibilities_text(self.sudoku.possible[row][column])
	
		self.fillPossible()
		#redo the highlighting
		self.grid.unhighlight_squares()
		self.highlightPatterns()
		self.highlightErrors()
		
		
	def highlightErrors(self):
		incorrect = self.sudoku.checkPuzzle()
		
		#for each thing that is incorrect
		for e in incorrect:
			#rows
			if e[0] == 1:
				#loop through each square in the row and turn it red
				for i in range(self.sudoku.SIZE):
					b = self.grid.__entries__[e[1]][i]
					b.set_background_color((0.7,0.1,0.1))
			elif e[0] == 2:
				#loop through each square in the column and turn it red
				for i in range(self.sudoku.SIZE):
					b = self.grid.__entries__[i][e[1]]
					b.set_background_color((0.7,0.1,0.1))
			elif e[0] == 3:
				#row2 and col2 are the corners
				row2 = e[1] + (math.sqrt(self.grid.size) - 1) 		#Defines size of box to check
				col2 = e[2] + (math.sqrt(self.grid.size) - 1)
				x = e[1]
				while (x <= row2):	#Cycles through the box
					y = e[2]
					while (y <= col2):      #finds the value in each of the squares of the box and removes them from check
						b = self.grid.__entries__[x][y]
						b.set_background_color((1,0,0))
						y = y + 1
					x = x + 1
	
	#initialise the interface
	def __init__(self):
		"""Reads in the glade file, shows the window, sets up the combobox and events"""
		print ("init window")
		#load in the glade file and show the window
		filename = "sudoku_gui.glade"
		builder = gtk.Builder()
		builder.add_from_file(filename)
		builder.connect_signals(self)
		self.window = builder.get_object('sudoku_window')
		self.grid = widgets.SudokuNumberGrid(9);
		self.vbox = builder.get_object('vbox1')
		self.vbox.add(self.grid)
		self.window.show()
		self.sudoku = Sudoku.Sudoku(9)
		
		#make the destroy event close the program
		if (self.window):
			self.window.connect("destroy", gtk.main_quit)

		
		#connect the new button to a new function
		self.newButton = builder.get_object('btnNew')
		self.newButton.connect("clicked", self.new, None)
		
		#connect the quit menu item to quitting the application
		self.menuQuit = builder.get_object('menuQuit')
		self.menuQuit.connect("activate", gtk.main_quit)
		
		#connect the new menu item to the same event as the new button
		self.menuNew = builder.get_object('menuNew')
		self.menuNew.connect("activate", self.new, None)
		
		#connect the open menu item to an event
		self.menuOpen = builder.get_object('menuOpen')
		self.menuOpen.connect("activate", self.open, None)
		
		#connect the save menu item to an event
		self.menuSave = builder.get_object('menuSave')
		self.menuSave.connect("activate", self.save, None)
		
		#connect the save as menu item to an event
		self.menuSaveAs = builder.get_object('menuSaveAs')
		self.menuSaveAs.connect("activate", self.saveAs, None)
		
		#connect the about menu item to an event
		self.menuAbout = builder.get_object('menuAbout')
		self.menuAbout.connect("activate", self.about, None)
		
		#connect the clear menu item to an event
		self.menuClear = builder.get_object('menuClear')
		self.menuClear.connect("activate", self.clear, None)
		
		#connect rowCol radio button to an event
		self.rowColRd = builder.get_object('rowCol')
		self.rowColRd.connect("pressed", self.rowCol, None)
		
		#connect rowNum radio button to an event
		self.rowNumRd = builder.get_object('rowNum')
		self.rowNumRd.connect("pressed", self.rowNum, None)
		
		#connect numCol radio button to an event
		self.numColRd = builder.get_object('numCol')
		self.numColRd.connect("pressed", self.numCol, None)
		
		#set rowCol as the default representation
		self.rowColRd.pressed()
		self.rowColRd.activate()
		
		self.btnCheck = builder.get_object('btnCheck')
		self.btnCheck.connect("clicked", self.isCompleteCallback, None)
		
		#self.btnCheck.clicked()
		
		#print "checked"
			
		#connect the events of all the boxes
		for row in range(self.sudoku.SIZE):
			for column in range(self.sudoku.SIZE):
				b = self.grid.__entries__[row][column]
				#print type(self.grid)
				#print type(b)
				b.show()
				b.connect('changed',self.changed_callback)
				#print (str(row) + " " + str(column) + " initialised")
			
			
#makes an interface object, then initialises gtk.main		   
if __name__ == "__main__":
	print "main interface.py"
	app = Interface()
	print "initialised interface, going into gtk.main"
	gtk.main()
